#include <ESPAsyncWebServer.h>
#include <ESP8266WiFi.h>
#include <FS.h>
#include <SPI.h>
#include <nRF24L01.h>
#include <RF24.h>


RF24 radio(4, 5);  // CE, CSN
const byte address[6] = { 'E', 'C', 'C', 'O', 2, 4 };

String data_in;

const char* wifi_ssid = "krt-telemetry";
const char* wifi_pass = "";

AsyncWebServer webserver(80);
AsyncWebSocket ws("/ws");

void setup() {
  //disableCore0WDT();
  //disableCore1WDT();
  Serial.begin(115200);

  Serial.print("Mounting SPIFFS... ");
  if (!SPIFFS.begin()) {
    Serial.println("FAIL");
  }
  Serial.println("OK");

  Serial.print("Starting WiFi hotspot... ");
  WiFi.enableAP(true);
  WiFi.mode(WIFI_AP);
  WiFi.softAPConfig(
    IPAddress(192, 168, 1, 1),
    IPAddress(192, 168, 1, 1),
    IPAddress(255, 255, 255, 0));
  WiFi.softAP(wifi_ssid, wifi_pass, 3, false, 4, false);
  Serial.println("OK");

  Serial.print("Initializing web server... ");
  webserver.addHandler(&ws);
  webserver.serveStatic("/", SPIFFS, "/");
  webserver.on("/", [](AsyncWebServerRequest* req) {
    req->send(SPIFFS, "/index.html", "text/html");
  });
  webserver.onNotFound([](AsyncWebServerRequest* req) {
    req->send(404, "404 - Not Found", "text/plain");
  });
  webserver.begin();
  Serial.println("OK");

  Serial.print("Establishing radio connection... ");
  radio.begin();
  radio.openReadingPipe(0, address);
  radio.setDataRate(RF24_250KBPS);
  radio.setPALevel(RF24_PA_HIGH);
  radio.startListening();
  Serial.println("OK");
}

long prevmillis = 0;

void loop() {
  /*if (radio.available()) {
    char rec[127] = "";
    radio.read(&rec, sizeof(rec));
    ws.textAll(rec);
    fs::File file = SPIFFS.open("/history.txt", FILE_APPEND);
    file.println(rec);
    file.close();
  }*/

  if(radio.available()) {
    char text[32] = "";
    radio.read(&text, sizeof(text));
    data_in += String(text);
    if(data_in.endsWith("\r\n")){
      //Serial.print(data_in);
      data_in.replace("\r\n","");
      ws.textAll(data_in);
      fs::File file = SPIFFS.open("/history.txt", "a");
      file.println(data_in);
      file.close();
      data_in = "";
    }
    Serial.print(text);
    
  }
  
  if (prevmillis+5000 < millis()){
	 	prevmillis = millis();
	 	ws.textAll("{\"kmph\": 0, \"V\": 0, \"A\": 0, \"W\": 0, \"mpWh\": 0, \"km\": 0, \"Wh\": 0, \"lvl\": 0}");
	 }
  ws.cleanupClients();
}
